#include <vpptype.h>

/*= Instrument bp2329.h Include File =============================================*/
/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15

/*== Gobale defines for Resisomat Typ 2329 =========================*/
#define BP2329_RESET_OFF    	0
#define BP2329_RESET_ON 	    1

#define BP2329_IEEE488_TIMEOUT_100msec  9
#define BP2329_IEEE488_TIMEOUT_300msec  10
#define BP2329_IEEE488_TIMEOUT_1sec  	11
#define BP2329_IEEE488_TIMEOUT_3sec  	12
#define BP2329_IEEE488_TIMEOUT_10sec  	13
#define BP2329_IEEE488_TIMEOUT_30sec  	14

#define BP2329_RS232_PORT_1			1
#define BP2329_RS232_PORT_2			2
#define BP2329_RS232_PORT_3			3
#define BP2329_RS232_PORT_4			4

#define BP2329_LOADING_OHMIC		0
#define BP2329_LOADING_INDUCTIVE	1

#define BP2329_MODE_SINGLE      0
#define BP2329_MODE_REPETITION  1

#define BP2329_AVERAGE_MOVING   0 
#define BP2329_AVERAGE_REPEAT   1 

#define BP2329_20MV_OFF       	0
#define BP2329_20MV_ON 	        1

#define BP2329_MEAS_SEQ_REF_COMP 	 	0
#define BP2329_MEAS_SEQ_NO_COMP  		1
#define BP2329_MEAS_SEQ_SINGLE_COMP  	2
#define BP2329_MEAS_SEQ_STANDARD 	  	3

#define BP2392_NUM_OF_CYCLES_MAXIMUM    0
#define BP2392_NUM_OF_CYCLES_MEDIUM		1
#define BP2392_NUM_OF_CYCLES_MINIMUM    2
#define BP2392_NUM_OF_CYCLES_STANDARD	3

#define BP2329_AUTO_RANGE       0
#define BP2329_RANGE_200m       1
#define BP2329_RANGE_2		    2
#define BP2329_RANGE_20		    3
#define BP2329_RANGE_200	    4
#define BP2329_RANGE_2K		    5
#define BP2329_RANGE_20K		6
#define BP2329_RANGE_200K		7


#define BP2329_DISPLAY_MODE_OHM 		0
#define BP2329_DISPLAY_MODE_DELTA 		1
#define BP2329_DISPLAY_MODE_COMPARATOR 	2


#define BP2329_DISPLAY_RESOLUTION_2000 		0
#define BP2329_DISPLAY_RESOLUTION_20000		1

#define BP2329_DISPLAY_RANGE_OFF			0
#define BP2329_DISPLAY_RANGE_ON				1

#define BP2329_DISPLAY_CURRENT_OFF			0
#define BP2329_DISPLAY_CURRENT_ON			1

#define BP2329_DISPLAY_TEMPERATURE_OFF		0
#define BP2329_DISPLAY_TEMPERATURE_ON		1

#define BP2329_DISPLAY_SAMPLE_OFF			0
#define BP2329_DISPLAY_SAMPLE_ON			1

#define BP2329_DISPLAY_TRIGGER_OFF			0
#define BP2329_DISPLAY_TRIGGER_ON			1

#define BP2329_DISPLAY_AUTO_MAN_OFF			0
#define BP2329_DISPLAY_AUTO_MAN_ON			1

#define BP2329_DISPLAY_LOAD_OFF				0
#define BP2329_DISPLAY_LOAD_ON				1

#define BP2329_DISPLAY_MEASURE_OFF			0
#define BP2329_DISPLAY_MEASURE_ON			1

#define BP2329_TCOMP_OFF					0
#define BP2329_TCOMP_ON						1

#define BP2329_TCOMP_TYPE_MANUAL	   		0
#define BP2329_TCOMP_TYPE_PT100				1
#define BP2329_TCOMP_TYPE_U_INPUT	   		2
#define BP2329_TCOMP_TYPE_I_INPUT	   		3

#define BP2329_TCOMP_MODE_U_INPUT	   		0
#define BP2329_TCOMP_MODE_I_INPUT	   		1

#define BP2329_ACCESS_MEASURE_OFF			0
#define BP2329_ACCESS_MEASURE_ON			1

#define BP2329_ACCESS_DISPLAY_OFF			0
#define BP2329_ACCESS_DISPLAY_ON			1

#define BP2329_ACCESS_PRINTER_OFF			0
#define BP2329_ACCESS_PRINTER_ON			1

#define BP2329_ACCESS_TCOMP_OFF				0
#define BP2329_ACCESS_TCOMP_ON				1

#define BP2329_ACCESS_CONTRAST_OFF			0
#define BP2329_ACCESS_CONTRAST_ON			1

#define BP2329_ACCESS_STORE_CONFIG_OFF		0
#define BP2329_ACCESS_STORE_CONFIG_ON		1

#define BP2329_ACCESS_INTERFACE_OFF			0
#define BP2329_ACCESS_INTERFACE_ON			1

#define BP2329_ACCESS_DISPLAY_STATE_OFF		0
#define BP2329_ACCESS_DISPLAY_STATE_ON		1


#define BP2329_ACCESS_AUX_INOUT_OFF			0
#define BP2329_ACCESS_AUX_INOUT_ON			1

#define BP2329_ACCESS_SCALE_OFF				0
#define BP2329_ACCESS_SCALE_ON				1

#define BP2329_ACCESS_DATALOGGER_OFF		0
#define BP2329_ACCESS_DATALOGGER_ON			1

#define BP2329_ACCESS_CALIBRATION_OFF		0
#define BP2329_ACCESS_CALIBRATION_ON		1

#define BP2329_ACCESS_DATE_OFF				0
#define BP2329_ACCESS_DATE__ON				1

#define BP2329_ACCESS_FAST_START_OFF		0
#define BP2329_ACCESS_FAST_START_ON			1

#define BP2329_ACCESS_COMP_CONFIG_OFF		0
#define BP2329_ACCESS_COMP_CONFIG_ON		1

#define BP2329_ACCESS_COMP_EVAL_OFF			0
#define BP2329_ACCESS_COMP_EVAL_ON			1

#define BP2329_ACCESS_ENVELOPE_CONFIG_OFF	0
#define BP2329_ACCESS_ENVELOPE_CONFIG_ON	1

#define BP2329_ACCESS_ENVELOPE_EVAL_OFF		0
#define BP2329_ACCESS_ENVELOPE_EVAL_ON		1

#define BP2329_ACCESS_RANGE_MANUAL_OFF		0
#define BP2329_ACCESS_RANGE_MANUAL_ON		1

#define BP2329_PRINTER_STOP					0
#define BP2329_PRINTER_START				1

#define BP2329_PRINT_TEMPERATURE_OFF		0
#define BP2329_PRINT_TEMPERATURE_ON			1

#define BP2329_PRINT_COUNTER_OFF			0
#define BP2329_PRINT_COUNTER_ON				1

#define BP2329_PRINT_LABEL_OFF				0
#define BP2329_PRINT_LABEL_ON				1

#define BP2329_PRINT_TIME_OFF				0
#define BP2329_PRINT_TIME_ON				1

#define BP2329_PRINT_DATE_OFF				0
#define BP2329_PRINT_DATE_ON				1

#define BP2329_COMPARATOR_OFF				0
#define BP2329_COMPARATOR_ON				1

#define BP2329_COMPARATOR_RELAIS_OFF		0
#define BP2329_COMPARATOR_RELAIS_ON			1

#define BP2329_COMPARATOR_ON_ERROR_NONE		0
#define BP2329_COMPARATOR_ON_ERROR_TOKEN	1

#define BP2329_ENVELOPE_OFF					0
#define BP2329_ENVELOPE_ON					1
									

#define BP2329_DATALOGGER_OFF				0
#define BP2329_DATALOGGER_ON				1

#define BP2329_DATALOGGER_FILTER_ALL		0
#define BP2329_DATALOGGER_FILTER_NOFAIL		1
#define BP2329_DATALOGGER_FILTER_FAIL		2
#define BP2329_DATALOGGER_FILTER_XVALUE		3
#define BP2329_DATALOGGER_FILTER_TIME		4
#define BP2329_DATALOGGER_FILTER_DELTAL		5

#define BP2329_DATALOGGER_SELECT_BY_NUMBER	0
#define BP2329_DATALOGGER_SELECT_BY_NAME	1


#define BP2329_OUTPUT_REGISTER_BIT0_OFF		0
#define BP2329_OUTPUT_REGISTER_BIT0_ON		1

#define BP2329_OUTPUT_REGISTER_BIT1_OFF		0
#define BP2329_OUTPUT_REGISTER_BIT1_ON		1

#define BP2329_OUTPUT_REGISTER_BIT2_OFF		0
#define BP2329_OUTPUT_REGISTER_BIT2_ON		1

#define BP2329_SYSTEM_KEYBOARD_UNLOCKED		0
#define BP2329_SYSTEM_KEYBOARD_LOCKED		1

#define BP2329_CALIBRATION_OFF				0
#define BP2329_CALIBRATION_ON				1

#define BP2329_CALIBRATION_RANGE_200m       0
#define BP2329_CALIBRATION_RANGE_2		    1
#define BP2329_CALIBRATION_RANGE_20		    2
#define BP2329_CALIBRATION_RANGE_200	    3
#define BP2329_CALIBRATION_RANGE_2K		    4
#define BP2329_CALIBRATION_RANGE_20K		5
#define BP2329_CALIBRATION_RANGE_200K		6

#define BP2329_CALIBRATION_20mV_LOW			0
#define BP2329_CALIBRATION_20mV_HIGH		1

#define BP2329_CALIBRATION_VOLTAGE_LOW		0
#define BP2329_CALIBRATION_VOLTAGE_HIGH		1

#define BP2329_CALIBRATION_PT100_LOW		0
#define BP2329_CALIBRATION_PT100_HIGH		1


/*== defines for program=======================================*/
#define bp2329_MAX_INSTR   10
#define bp2329_MAX_CMD     300
#define bp2329_GPIB        0
#define bp2329_SERIAL      1
#define bp2329_MAX_BINN_LIMIT      8       /* SORT:BINN  => 8 Limit's */

#define bp2329_DEVICE_CALIBRATION (1<<0)   /* Bit 0 of Operation Status Registers*/
#define bp2329_MEASURING          (1<<4)   /* Bit 4 of Operation Status Registers*/
#define bp2329_EOC                (1<<8)   /* Bit 8 of Operation Status Registers*/

#define bp2329_DEVICE_DEP_ERROR   (1<<3)   /* Bit 3 of Standard Event Registers*/
#define bp2329_EXECUATION_ERROR   (1<<4)   /* Bit 4 of Standard Event Registers*/


#define bp2329_FRES_ERROR         (1<<9)   /* Bit 9 of Questionable Status Registers*/
#define bp2329_CAL_ERROR          (1<<8)   /* Bit 8 of Questionable Status Registers*/
#define bp2329_TEMP_ERROR         (1<<4)   /* Bit 4 of Questionable Status Registers*/


#define bp2329_TEMP_KOMP_ERROR    (1<<7)   /* Bit 7 of Questionable FResistance Registers*/
#define bp2329_U_CABLE_ERROR      (1<<6)   /* Bit 6 of Questionable FResistance Registers*/
#define bp2329_I_OSCILLATION      (1<<5)   /* Bit 5 of Questionable FResistance Registers*/
#define bp2329_UNDER_LOAD         (1<<4)   /* Bit 4 of Questionable FResistance Registers*/
#define bp2329_OVER_LOAD          (1<<3)   /* Bit 3 of Questionable FResistance Registers*/
#define bp2329_I_OVER             (1<<2)   /* Bit 2 of Questionable FResistance Registers*/
#define bp2329_MU_OVER            (1<<1)   /* Bit 1 of Questionable FResistance Registers*/
#define bp2329_MI_OVER            (1<<0)   /* Bit 0 of Questionable FResistance Registers*/

#define bp2329_SRQ_OPER_REG       (1<<7)   /* Bit 7 of SRQ-Register*/
#define bp2329_SRQ_QUEST_REG      (1<<3)   /* Bit 3 of SRQ-Register*/

/*= GLOBAL FUNCTION DECLARATIONS ==========================================*/

int _VI_FUNC  bp2329_init_gpib (int address, int timeout, int reset,
                      char instrumentIDString[], int *instrumentID);
int _VI_FUNC  bp2329_init_serial (int COMPort, int baudRate, double timeoutseconds,
                        char instrumentIDString[], int reset, int *instrumentID);
int _VI_FUNC  bp2329_local_gpib (int instrumentID);
int _VI_FUNC  bp2329_set_config_meas (int instrumentID, int averageMode, int averageCounts,
                            int loading, int measurementMode, int _20mVLimit,
                            int measurementSequence, int numofConvertsCycles);
int _VI_FUNC  bp2329_get_config_meas (int instrumentID, int *averageMode, int *averageCounts,
                            int *loading, int *measurementMode, int *_20mVLimit,
                            int *measurementSequence, int *numofConvertsCycles);
int _VI_FUNC  bp2329_set_config_range (int instrumentID, int range);
int _VI_FUNC  bp2329_get_config_range (int instrumentID, int *range);
int _VI_FUNC  bp2329_set_config_auto_range (int instrumentID, int lowerAutoRange,
                                  int upperAutoRange);
int _VI_FUNC  bp2329_get_config_auto_range (int instrumentID, int *lowerAutoRange,
                                  int *upperAutoRange);
int _VI_FUNC  bp2329_set_config_display_mode (int instrumentID, int displayMode,
                                    double deltaNominalValue, int resolution);
int _VI_FUNC  bp2329_get_config_display_mode (int instrumentID, int *displayMode,
                                    double *deltaNominalValue, int *resolution);
int _VI_FUNC  bp2329_set_config_display_options (int instrumentID, int rangeOption,
                                       int currentOption, int temperatureOption,
                                       int sampleOption, int triggerOption,
                                       int autoManOption, int loadOption,
                                       int measureOption);
int _VI_FUNC  bp2329_get_config_display_options (int instrumentID, int *rangeOption,
                                       int *currentOption, int *temperatureOption,
                                       int *sampleOption, int *triggerOption,
                                       int *autoManOption, int *loadOption,
                                       int *measureOption);
int _VI_FUNC  bp2329_set_config_display_contrast (int instrumentID, double displayContrast);
int _VI_FUNC  bp2329_get_config_display_contrast (int instrumentID, double *displayContrast);
int _VI_FUNC  bp2329_set_config_temp_compensation (int instrumentID, int compensationState,
                                         int compensationType,
                                         double refernceTemperature,
                                         double manualTemperature);
int _VI_FUNC  bp2329_get_config_temp_compensation (int instrumentID, int *compensationState,
                                         int *compensationType,
                                         double *referenceTemperature,
                                         double *manualTemperature);
int _VI_FUNC  bp2329_get_temp_value(int instrID,double* value);                                         
int _VI_FUNC  bp2329_set_config_scale_pt100 (int instrumentID, double r0, double coefficienta,
                                   double coefficientb);
int _VI_FUNC  bp2329_get_config_scale_pt100 (int instrumentID, double *r0,
                                   double *coefficienta, double *coefficientb);
int _VI_FUNC  bp2329_set_config_scale_ui_input (int instrumentID, int mode, double u1I1,
                                      double u2I2, double t1, double t2);
int _VI_FUNC  bp2329_get_config_scale_ui_input (int instrumentID, int mode, double *u1I1,
                                      double *u2I2, double *t1, double *t2);
int _VI_FUNC  bp2329_set_config_temp_coefficient (int instrumentID, int numberofCoeff,
                                        int coeffValueppmk);
int _VI_FUNC  bp2329_get_config_temp_coefficient (int instrumentID, int numberofCoeff,
                                        int *coeffValueppmk);
int _VI_FUNC  bp2329_set_active_temp_coefficient (int instrumentID, int numberofCoeff);
int _VI_FUNC  bp2329_get_active_temp_coefficient (int instrumentID, int *coeffValue);
int _VI_FUNC  bp2329_set_config_device_access (int instrumentID, int measureMenu,
                                     int displayMenu, int printerMenu,
                                     int tempCompMenu, int contrastMenu,
                                     int storeConfigMenu, int interfaceMenu,
                                     int displayStateMenu, int auxInOutMenu,
                                     int scaleMenu, int dataloggerMenu,
                                     int calibrationMenu, int dateMenu,
                                     int fastStartMenu, int comparaConfMenu,
                                     int comparaEvalMenu, int envelopeConfMenu,
                                     int envelopeEvalMenu, int manRangeMenu);
int _VI_FUNC  bp2329_get_config_device_access (int instrumentID, int *measureMenu,
                                     int *displayMenu, int *printerMenu,
                                     int *tempCompMenu, int *contrastMenu,
                                     int *storeConfigMenu, int *interfaceMenu,
                                     int *displayStateMenu, int *auxInOutMenu,
                                     int *scaleMenu, int *dataloggerMenu,
                                     int *calibrationMenu, int *dateMenu,
                                     int *fastStartMenu, int *comparaConfMenu,
                                     int *comparaEvalMenu, int *envelopeConfMenu,
                                     int *envelopeEvalMenu, int *manRangeMenu);
int _VI_FUNC  bp2329_set_config_printer_state (int instrumentID, int printerState);
int _VI_FUNC  bp2329_set_config_printer_mode (int instrumentID, int printTemperature,
                                    int printCounter, int printLabel, int printTime,
                                    int printDate, int measValuesHeader,
                                    char labelText[], int HH, int MM, int SS);
int _VI_FUNC  bp2329_get_config_printer_mode (int instrumentID, int *printTemperature,
                                    int *printCounter, int *printLabel,
                                    int *printTime, int *printDate,
                                    int *measValuesHeader, char labelText[],
                                    int *HH, int *MM, int *SS);
int _VI_FUNC  bp2329_printer_counter_reset (int instrumentID);
int _VI_FUNC  bp2329_set_config_memory_label (int instrumentID, int memoryNo,
                                    char memoryLabel[]);
int _VI_FUNC  bp2329_get_config_memory_label (int instrumentID, int memoryNo,
                                    char memoryLabel[]);
int _VI_FUNC  bp2329_set_config_memory (int instrumentID, int memoryNo);
int _VI_FUNC  bp2329_get_config_memory (int instrumentID, int memoryNo);
int _VI_FUNC  bp2329_meas_start (int instrumentID);
int _VI_FUNC  bp2329_meas_read (int instrumentID, double *measuredValue, char unit[]);
int _VI_FUNC  bp2329_meas_read_string (int instrumentID, char measuredValue[]);
int _VI_FUNC  bp2329_meas_stop (int instrumentID);
int _VI_FUNC  bp2329_set_config_comparator_mode (int instrumentID, int state, int relaisMode,
                                       int onError);
int _VI_FUNC  bp2329_get_config_comparator_mode (int instrumentID, int *state,
                                       int *relaisMode, int *onError);
int _VI_FUNC  bp2329_set_config_2_limit_comparator (int instrumentID, double lowerLimit,
                                          double upperLimit);
int _VI_FUNC  bp2329_get_config_2_limit_comparator (int instrumentID, double *lowerLimit,
                                          double *upperLimit);
int _VI_FUNC  bp2329_set_config_4_limit_comparator (int instrumentID, double limit1,
                                          double limit2, double limit3,
                                          double limit4);
int _VI_FUNC  bp2329_get_config_4_limit_comparator (int instrumentID, double *limit1,
                                          double *limit2, double *limit3,
                                          double *limit4);
int _VI_FUNC  bp2329_comparator_2_limit_report (int instrumentID, int *value1, int *value2,
                                      int *value3);
int _VI_FUNC  bp2329_comparator_4_limit_report (int instrumentID, int *value1, int *value2,
                                      int *value3, int *value4, int *value5);
int _VI_FUNC  bp2329_comparator_clear (int instrumentID);
int _VI_FUNC  bp2329_set_envelope_state (int instrumentID, int state);
int _VI_FUNC  bp2329_get_envelope_state (int instrumentID, int *state);
int _VI_FUNC  bp2329_envelope_read_report (int instrumentID, char minValue[], char maxValue[],
                                 char diffValue[]);
int _VI_FUNC  bp2329_envelope_clear (int instrumentID);
int _VI_FUNC  bp2329_set_datalogger_state (int instrumentID, int datenloggerState);
int _VI_FUNC  bp2329_get_datalogger_state (int instrumentID, int *datenloggerState);
int _VI_FUNC  bp2329_set_datalogger_name (int instrumentID, int blockNo, char name[]);
int _VI_FUNC  bp2329_get_datalogger_name (int instrumentID, int blockNo, char name[]);
int _VI_FUNC  bp2329_set_datalogger_block_size (int instrumentID, int blockNo, int blockSize);
int _VI_FUNC  bp2329_get_datalogger_block_size (int instrumentID, int blockNo, int *blockSize);
int _VI_FUNC  bp2329_set_datalogger_filter (int instrumentID, int blockNo, int filter,
                                  int XValue, int HH, int MM, int SS, double delta);
int _VI_FUNC  bp2329_get_datalogger_filter (int instrumentID, int blockNo, int *filter,
                                  int *XValue, int *HH, int *MM, int *SS,
                                  double *delta);
int _VI_FUNC  bp2329_datalogger_clear_block (int instrumentID, int block);
int _VI_FUNC  bp2329_set_active_datalogger_block (int instrumentID, int selectMode,
                                        int blockNo, char name[]);
int _VI_FUNC  bp2329_get_active_datalogger_block (int instrumentID, int *blockNo);
int _VI_FUNC  bp2329_datalogger_read_num_counts (int instrument_ID, int blockNo, int *count);
int _VI_FUNC  bp2329_datalogger_read_block (int instrumentID, int blockNo, int startNumber,
                                  char value[], char date[], char time[]);
int _VI_FUNC  bp2329_datalogger_read_eval_values (int instrumentID, int blockNo,
                                        char minimum[], char maximum[],
                                        char meanValue[], char stdDeviation[]);
int _VI_FUNC  bp2329_system_set_register (int instrumentID, int bit2, int bit1, int bit0);
int _VI_FUNC  bp2329_system_get_register (int instrumentID, int *bit3, int *bit2, int *bit1,
                                int *bit0);
int _VI_FUNC  bp2329_system_date_time (int instrumentID, int HH, int MM, int SS, int day,
                             int month, int year);
int _VI_FUNC  bp2329_system_error (int instrumentID);
int _VI_FUNC  bp2329_system_keyboard (int instrumentID, int keyboard);
int _VI_FUNC  bp2329_cal_state (int instrumentID, int state);
int _VI_FUNC  bp2329_cal_fres (int instrumentID, int range, double value);
int _VI_FUNC  bp2329_cal_20mV_mode (int instrumentID, int mode);
int _VI_FUNC  bp2329_cal_20mV_init (int instrumentID);
int _VI_FUNC  bp2329_cal_20mV (int instrumentID, double resistanceValueca200mOhm,
                     double lowVoltage, double highVoltage);
int _VI_FUNC  bp2329_cal_voltage_mode (int instrumentID, int mode);
int _VI_FUNC  bp2329_cal_voltage (int instrumentID, double lowVoltage, double highVoltage);
int _VI_FUNC  bp2329_cal_current (int instrumentID, double currentValue);
int _VI_FUNC  bp2329_cal_pt100_mode (int instrumentID, int mode, double value);
int _VI_FUNC  bp2329_cal_pt100 (int instrumentID);
int _VI_FUNC  bp2329_send_scpi (int instrumentID, char sendSCPIMessage[]);
int _VI_FUNC  bp2329_receive_scpi (int instrumentID, char sendSCPIMessage[],
                         char answerfromSlave[]);
int _VI_FUNC  bp2329_close (int instrumentID);



